/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.commands.translations;

import io.leangen.geantyref.TypeToken;
import java.util.Locale;
import java.util.Set;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.translations.metadata.LanguageInfo;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.core.translations.internal.ImpactorTranslations;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Permission;
import org.incendo.cloud.annotations.processing.CommandContainer;
import org.jetbrains.annotations.NotNull;

@CommandContainer
@Permission(value={"impactor.commands.translations.base"})
public final class TranslationCommands {
    @Command(value="translations view <language>")
    @Permission(value={"impactor.commands.translations.view"})
    public void view(@NotNull CommandSource source2, @Argument(value="language") Locale locale) {
        ImpactorTranslations.TRANSLATIONS_SEARCHING.send(source2, Context.empty());
        Context context = Context.empty();
        Set<LanguageInfo> languages = ImpactorTranslations.MANAGER.repository().available().join();
        LanguageInfo target = languages.stream().filter(info -> info.locale().equals(locale)).findFirst().orElse(null);
        if (target == null) {
            ImpactorTranslations.TRANSLATIONS_INVALID_LOCALE.send(source2, context);
            return;
        }
        context.append(LanguageInfo.class, target);
        ImpactorTranslations.TRANSLATIONS_INFO_HEADER_FOOTER.send(source2, context);
        ImpactorTranslations.TRANSLATIONS_INFO_LANGUAGE.send(source2, context);
        ImpactorTranslations.TRANSLATIONS_INFO_PROGRESS.send(source2, context);
        ImpactorTranslations.TRANSLATIONS_INFO_CONTRIBUTOR_HEADER.send(source2, context);
        target.contributors().forEach(contributor -> {
            Context ctx = Context.empty().with(context).append(String.class, contributor);
            ImpactorTranslations.TRANSLATIONS_INFO_CONTRIBUTOR_NAME.send(source2, ctx);
        });
        ImpactorTranslations.TRANSLATIONS_INFO_HEADER_FOOTER.send(source2, context);
    }

    @Command(value="translations install")
    @Permission(value={"impactor.commands.translations.install"})
    public void install(@NotNull CommandSource source2) {
        ImpactorTranslations.TRANSLATIONS_SEARCHING.send(source2, Context.empty());
        Set<LanguageInfo> languages = ImpactorTranslations.MANAGER.repository().available().join();
        Context context = Context.empty();
        context.append(new TypeToken<Set<LanguageInfo>>(this){}, languages);
        ImpactorTranslations.TRANSLATIONS_INSTALLING.send(source2, context);
        ImpactorTranslations.MANAGER.repository().downloadAndInstall(languages, source2, true).join();
        ImpactorTranslations.TRANSLATIONS_INSTALL_COMPLETE.send(source2, context);
    }
}

